(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 4.2'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     22487,        877]*)
(*NotebookOutlinePosition[     23390,        907]*)
(*  CellTagsIndexPosition[     23346,        903]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[TextData["Exact Differential Equations"], "Subtitle",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[TextData[
"The theory of exact differential equations is inherited directly from \
multidimensional calculus. Solution methods are the same as that for \
potential functions."], "Text",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell["Definition for the gradient:", "Subsubtitle"],

Cell[BoxData[
    \(grad[expr_, vars_] := 
      Map[\((\[PartialD]\_#\ expr)\) &, vars]\)], "Input"],

Cell["Here is how it works:", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(grad[q[x, y, z], {x, y, z}]\)], "Input"],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        RowBox[{
          SuperscriptBox["q", 
            TagBox[\((1, 0, 0)\),
              Derivative],
            MultilineFunction->None], "[", \(x, y, z\), "]"}], ",", 
        RowBox[{
          SuperscriptBox["q", 
            TagBox[\((0, 1, 0)\),
              Derivative],
            MultilineFunction->None], "[", \(x, y, z\), "]"}], ",", 
        RowBox[{
          SuperscriptBox["q", 
            TagBox[\((0, 0, 1)\),
              Derivative],
            MultilineFunction->None], "[", \(x, y, z\), "]"}]}], 
      "}"}]], "Output"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["****Equations in Two Variables ****", "Subsubtitle",
  CellFrame->{{0, 0}, {0, 2}},
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[TextData["Theory "], "Section",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[TextData[{
  "If both mixed partials of ",
  StyleBox["f[x, y]", "Input"],
  " are continuous in a region  R  then these are equal: \n\t ",
  StyleBox["D[f[x, y],{x,y}]===D[f[x, y],{y,x}],",
    FontWeight->"Bold"],
  "\nand furthermore if ",
  StyleBox["V[x, y]={p[x, y], q[x, y]}", "Input"],
  " is a vector field such that \n\t ",
  StyleBox["D[p[x, y], y]===D[q[x, y], x],",
    FontWeight->"Bold"],
  "\nthen there is a (potential) function f[x, y] such that \n\t ",
  StyleBox["grad[f[x, y],{x,y}]==={p[x, y], q[x, y]}.",
    FontWeight->"Bold"],
  "\nIn addition, if the region R is convex, then the integral of ",
  StyleBox["V[x, y]", "Input"],
  " along any piecewise continuous curve C within R  depends only on the \
endpoints of integration and not on the path C itself.  We use this latter \
property to obtain a solution to exact differential equations in two and \
three variables."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->False]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData["Definition "], "Section",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[TextData[{
  "A differential equation  ",
  StyleBox["p[x, y] dx + q[x, y] dy == 0", "Input",
    FontWeight->"Bold"],
  " defined on a convex region R is called exact provided that ",
  StyleBox["D[p[x, y], y]===D[q[x, y], x]", "Input",
    FontWeight->"Bold"],
  StyleBox[".",
    FontWeight->"Bold"],
  "  This means that the vector field \n",
  StyleBox["V[x, y]={p[x, y], q[x, y]}", "Input"],
  " has a potential function. It is one such potential function which we seek \
as the solution of our differential equation."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->False]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData["Solution method "], "Section",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[TextData[{
  "Since our equation is exact and our region is convex, we have the \
'independence of  path property'.  Assuming that we start at the point ",
  StyleBox["{x0, y0}", "Input"],
  ", we choose a broken-line path to  the point ",
  StyleBox["{x, y}", "Input"],
  " by first going parallel to the x-axis to the point ",
  StyleBox["{x, y0}", "Input"],
  " and thence to the point ",
  StyleBox["{x, y}", "Input"],
  ". Our solution ",
  StyleBox["f[x, y]", "Input"],
  " is then expressed as:"
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[TextData[Cell[BoxData[
    \(f[x_, y_] := 
      f[x0, y0] + \[Integral]\_x0\%x p[t, 
              y0] \[DifferentialD]t + \[Integral]\_y0\%y q[x, 
              s] \[DifferentialD]s\)],
  FontWeight->"Bold"]], "Text",
  Evaluatable->False,
  AspectRatioFixed->False]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData["Examples (two variables)"], "Section",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[TextData[
"These two-variable examples are similar to, but different from, the examples \
in the text."], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell[TextData["Example 1"], "Subsection",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[BoxData[
    \(Clear[f, x, y, p, q, x0, y0, t, s]\)], "Input"],

Cell[TextData[{
  "Solve the exact differential equation ",
  StyleBox["(2x-5y)dx+(-5x+3y^2)dy==0, y(1)==2", "Input"],
  "."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[TextData["Here we have:"], "Text",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[BoxData[{
    \(p[x_, y_] = 2\ x - 5\ y\), "\n", 
    \(q[x_, y_] = \(-5\)\ x + 3\ y\^2\)}], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \(2\ x - 5\ y\)], "Output"],

Cell[BoxData[
    \(\(-5\)\ x + 3\ y\^2\)], "Output"]
}, Closed]],

Cell[TextData["Check that the equation is exact:"], "Text",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[BoxData[
    \(\[PartialD]\_y p[x, y]\)], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \(\(-5\)\)], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\[PartialD]\_x q[x, y]\)], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \(\(-5\)\)], "Output"]
}, Closed]],

Cell[TextData[
"These are equal, so the equation is exact.  As claimed above we can define a \
solution as:"], "Text",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[BoxData[{
    \(x0 = 1\), "\n", 
    \(y0 = 2\), "\n", 
    \(f[x_, 
        y_] = \[Integral]\_x0\%x p[t, 
              y0] \[DifferentialD]t + \[Integral]\_y0\%y q[x, 
              s] \[DifferentialD]s\)}], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \(1\)], "Output"],

Cell[BoxData[
    \(2\)], "Output"],

Cell[BoxData[
    \(1 + x\^2 - 5\ x\ y + y\^3\)], "Output"]
}, Closed]],

Cell[TextData["Check that this is indeed a solution:"], "Text",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[BoxData[
    \(grad[f[x, y], {x, y}] == {p[x, y], q[x, y]}\)], "Input"],

Cell[BoxData[
    \(True\)], "Output"]
}, Closed]],

Cell[TextData[
"We have a solution.  The solution can be described implicitly by:"], "Text",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[BoxData[
    \(f[x, y] == 0\)], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \(1 + x\^2 - 5\ x\ y + y\^3 == 0\)], "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData["Example 2"], "Subsection",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[BoxData[
    \(Clear[f, x, y, p, q, x0, y0, t, s]\)], "Input"],

Cell[TextData[{
  "Solve the exact differential equation ",
  StyleBox["(2x-5y)dx+(-5x+3y^2)dy==0, y(2)==3", "Input"],
  "."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[TextData["Here we have:"], "Text",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[BoxData[{
    \(p[x_, y_] = 2\ x\ y\), "\n", 
    \(q[x_, y_] = x\^2 - 1\)}], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \(2\ x\ y\)], "Output"],

Cell[BoxData[
    \(\(-1\) + x\^2\)], "Output"]
}, Closed]],

Cell[TextData["Check that the equation is exact:"], "Text",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[BoxData[
    \(\[PartialD]\_y p[x, y]\)], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \(2\ x\)], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\[PartialD]\_x q[x, y]\)], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \(2\ x\)], "Output"]
}, Closed]],

Cell[TextData[
"These are equal, so the equation is exact.  As claimed above we can define a \
solution as:"], "Text",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[BoxData[{
    \(x0 = 2\), "\n", 
    \(y0 = 3\), "\n", 
    \(f[x_, 
        y_] = \[Integral]\_x0\%x p[t, 
              y0] \[DifferentialD]t + \[Integral]\_y0\%y q[x, 
              s] \[DifferentialD]s\)}], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \(2\)], "Output"],

Cell[BoxData[
    \(3\)], "Output"],

Cell[BoxData[
    \(6\ \((\(-2\) + x\^2\/2)\) - 
      3\ \((\(-1\) + x\^2)\) + \((\(-1\) + x\^2)\)\ y\)], "Output"]
}, Closed]],

Cell[TextData["Check that this is indeed a solution:"], "Text",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[BoxData[
    \(grad[f[x, y], {x, y}] == {p[x, y], q[x, y]}\)], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \(True\)], "Output"]
}, Closed]],

Cell[TextData[
"We have a solution.  The solution can be described implicitly by:"], "Text",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[BoxData[
    \(f[x, y] == 0 // Simplify\)], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \(\((\(-1\) + x\^2)\)\ y == 9\)], "Output"]
}, Closed]]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["****Equations in Three Variables ****", "Subsubtitle",
  CellFrame->{{0, 0}, {0, 2}},
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell["Theory ", "Section",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[TextData[{
  "If all mixed partials of ",
  StyleBox["f[x, y, z]", "Input"],
  " are continuous in a region  R  then these are equal: \n\t",
  StyleBox["D[f[x, y, z],{x, y}]===D[f[x, y, z],{y, x}]===D[f[x, y, z],{z, \
x}], etc.",
    FontWeight->"Bold"],
  "\nas are all second-order partials if they are continuous.\nFurthermore if \
",
  StyleBox["V[x, y]={p[x, y, z], q[x, y, z],r[x, y, z]}", "Input"],
  " is a vector field such that \n\t",
  StyleBox["D[f[x, y, z],{x, y}]===D[f[x, y, z],{y, x}]===D[f[x, y, z],{z, \
x}], etc.",
    FontWeight->"Bold"],
  "\nare all equal, then there is a (potential) function ",
  StyleBox["phi[x, y, z]", "Input"],
  " such that \n\t",
  StyleBox["grad[phi[x, y, z]]==={p[x, y, z], q[x, y, z], r[x, y, z]}.",
    FontWeight->"Bold"],
  "\nIn addition, if the region R is convex, then the integral of ",
  StyleBox["V[x, y, z]", "Input"],
  " along any piecewise continuous curve C within R  depends only on the \
endpoints of integration and not on the path C itself.  We use this latter \
property to obtain a solution."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->False]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData["Definition "], "Section",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[TextData[{
  "A differential equation  ",
  StyleBox["p[x, y, z] dx + q[x, y, z] dy + r[x, y, z]dz == 0",
    FontWeight->"Bold"],
  " defined on a convex region R of 3-space is called exact provided that \n\
",
  Cell[BoxData[
      StyleBox[
        RowBox[{
          FractionBox[\(\[PartialD]p \((x, y, z)\)\), \(\[PartialD]y\),
            MultilineFunction->None], "==", 
          FractionBox[\(\[PartialD]q \((x, y, z)\)\), \(\[PartialD]x\),
            MultilineFunction->None]}],
        FontWeight->"Plain"]], "Input",
    FontSize->14],
  ",",
  StyleBox["\n",
    FontWeight->"Bold"],
  Cell[BoxData[
      StyleBox[
        RowBox[{
          FractionBox[\(\[PartialD]p \((x, y, z)\)\), \(\[PartialD]z\),
            MultilineFunction->None], "==", 
          FractionBox[\(\[PartialD]r \((x, y, z)\)\), \(\[PartialD]x\),
            MultilineFunction->None]}],
        FontSize->14]]],
  ", and",
  StyleBox["\n",
    FontWeight->"Bold"],
  Cell[BoxData[
      StyleBox[
        RowBox[{
          FractionBox[\(\[PartialD]q \((x, y, z)\)\), \(\[PartialD]z\),
            MultilineFunction->None], "==", 
          FractionBox[\(\[PartialD]r \((x, y, z)\)\), \(\[PartialD]y\),
            MultilineFunction->None]}],
        FontSize->14]]],
  StyleBox[".",
    FontWeight->"Bold"],
  "  \nThis means that the vector field ",
  StyleBox["V[x, y, z]={p[x, y, z], q[x, y, z], r[x, y, z]}", "Input"],
  " has a potential function. It is one such potential function which we seek \
as the solution of our differential equation."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->False]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData["Solution method "], "Section",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[TextData[{
  "To solve the exact differential equation in three variables:\n\t",
  StyleBox["p[x, y, z]dx+q[x, y, z}dy+r[x, y, z]dz==0", "Input",
    FontWeight->"Bold"],
  "\nSince our equation is exact and our region is convex in 3-space, we have \
the 'independence of  path property'.  Assuming that we start at the point ",
  StyleBox["{x0, y0, z0}", "Input"],
  ", we choose a broken-line path to  the point ",
  StyleBox["{x, y,z}", "Input"],
  " by first going parallel to the x-axis to the point ",
  StyleBox["{x, y0, z0}", "Input"],
  " and thence to the point ",
  StyleBox["{x, y, z0}", "Input"],
  " and on to ",
  StyleBox["{x, y, z}", "Input"],
  ". Our solution ",
  StyleBox["phi[x, y, z] ", "Input"],
  "is then expressed as:"
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[BoxData[
    \(phi[x_, y_, z_] := 
      C + \[Integral]\_x0\%x p[s, y0, 
              z0] \[DifferentialD]s + \[Integral]\_y0\%y q[x, t, 
              z0] \[DifferentialD]t + \[Integral]\_z0\%z r[x, y, 
              u] \[DifferentialD]u\)], "Text",
  Evaluatable->False,
  AspectRatioFixed->False]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData["Examples (three variables)"], "Section",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[TextData[
"These three-variable examples are similar to, but different from, the \
examples in the text."], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell[TextData["Example 1"], "Subsection",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[TextData[{
  "Solve the exact differential equation \n",
  Cell[BoxData[
      \(\((1 + 2\ x\ y\^3 - 2\ y\^2\ z)\)\ dx + \((3\ x\^2\ y\^2 - 
                4\ x\ y\ z - 5\ z\^2)\)\ dy + \((\(-4\) - 2\ x\ y\^2 - 
                10\ y\ z)\)\ dz == 0\)]],
  ", at {2,-1,3}."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[TextData["Here we have:"], "Text",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[BoxData[{
    \(Clear[p, q, r, x, y, z, phi, s, t, u]\), "\n", 
    \(p[x_, y_, z_] = 1 + 2\ x\ y\^3 - 2\ y\^2\ z\), "\n", 
    \(q[x_, y_, z_] = 3\ x\^2\ y\^2 - 4\ x\ y\ z - 5\ z\^2\), "\n", 
    \(r[x_, y_, z_] = \(-4\) - 2\ x\ y\^2 - 10\ y\ z\)}], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \(1 + 2\ x\ y\^3 - 2\ y\^2\ z\)], "Output"],

Cell[BoxData[
    \(3\ x\^2\ y\^2 - 4\ x\ y\ z - 5\ z\^2\)], "Output"],

Cell[BoxData[
    \(\(-4\) - 2\ x\ y\^2 - 10\ y\ z\)], "Output"]
}, Closed]],

Cell[TextData["Check that the equation is exact:"], "Text",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[BoxData[
    \(\[PartialD]\_y p[x, y, z] === \[PartialD]\_x q[x, y, z]\)], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \(True\)], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\[PartialD]\_z p[x, y, z] === \[PartialD]\_x r[x, y, z]\)], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \(True\)], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\[PartialD]\_z q[x, y, z] === \[PartialD]\_y r[x, y, z]\)], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \(True\)], "Output"]
}, Closed]],

Cell["\<\
The three equalities hold, so the equation is exact.  As claimed \
above we can define a solution as:\
\>", "Text",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[BoxData[{
    \(x0 = 2\), "\n", 
    \(y0 = \(-1\)\), "\n", 
    \(z0 = 3\), "\n", 
    \(phi[x_, y_, 
        z_] = \[Integral]\_x0\%x p[s, y0, 
              z0] \[DifferentialD]s + \[Integral]\_y0\%y q[x, t, 
              z0] \[DifferentialD]t + \[Integral]\_z0\%z r[x, y, 
              u] \[DifferentialD]u\)}], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \(2\)], "Output"],

Cell[BoxData[
    \(\(-1\)\)], "Output"],

Cell[BoxData[
    \(3\)], "Output"],

Cell[BoxData[
    \(\(-19\) + x + x\^2\ y\^3 - 4\ z - 2\ x\ y\^2\ z - 
      5\ y\ z\^2\)], "Output"]
}, Closed]],

Cell[TextData["Check that this is indeed a solution:"], "Text",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[BoxData[
    \(ExpandAll[
      grad[phi[x, y, z], {x, y, z}] == {p[x, y, z], q[x, y, z], 
          r[x, y, z]}]\)], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \(True\)], "Output"]
}, Closed]],

Cell[TextData[
"We have a solution.  The solution can be described implicitly by:"], "Text",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[BoxData[
    \(ExpandAll[phi[x, y, z]] == 0\)], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \(\(-19\) + x + x\^2\ y\^3 - 4\ z - 2\ x\ y\^2\ z - 5\ y\ z\^2 == 
      0\)], "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData["Example 2"], "Subsection",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell["Solve the exact differential equation ", "Text",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[BoxData[
    \(\(\(\((E^z*y + z*Sin[y])\) dx + \((E^z*x + x*z*Cos[y])\) 
          dy + \((E^z*x*y + x*Sin[y])\) dz \[Equal] 0\)\(,\)\)\)], "Text",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[TextData[{
  "at the point ",
  StyleBox["{0, \[Pi], 0}", "Input"],
  "."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[TextData["Here we have:"], "Text",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[BoxData[{
    \(Clear[p, q, r, x, y, z]\), "\n", 
    \(p[x_, y_, z_] = E\^z\ y + z\ Sin[y]\), "\n", 
    \(q[x_, y_, z_] = E\^z\ x + x\ z\ Cos[y]\), "\n", 
    \(r[x_, y_, z_] = E\^z\ x\ y + x\ Sin[y]\)}], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \(\[ExponentialE]\^z\ y + z\ Sin[y]\)], "Output"],

Cell[BoxData[
    \(\[ExponentialE]\^z\ x + x\ z\ Cos[y]\)], "Output"],

Cell[BoxData[
    \(\[ExponentialE]\^z\ x\ y + x\ Sin[y]\)], "Output"]
}, Closed]],

Cell[TextData["Check that the equation is exact:"], "Text",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[BoxData[
    \(\[PartialD]\_y p[x, y, z] === \[PartialD]\_x q[x, y, z]\)], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \(True\)], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\[PartialD]\_z p[x, y, z] === \[PartialD]\_x r[x, y, z]\)], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \(True\)], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\[PartialD]\_z q[x, y, z] === \[PartialD]\_y r[x, y, z]\)], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \(True\)], "Output"]
}, Closed]],

Cell[TextData[
"These are equal, so the equation is exact.  As claimed above we can define a \
solution as:"], "Text",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[BoxData[{
    \(x0 = 0\), "\n", 
    \(y0 = \[Pi]\), "\n", 
    \(z0 = 0\), "\n", 
    \(phi[x_, y_, 
        z_] = \[Integral]\_x0\%x p[s, y0, 
              z0] \[DifferentialD]s + \[Integral]\_y0\%y q[x, t, 
              z0] \[DifferentialD]t + \[Integral]\_z0\%z r[x, y, 
              u] \[DifferentialD]u\)}], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \(0\)], "Output"],

Cell[BoxData[
    \(\[Pi]\)], "Output"],

Cell[BoxData[
    \(0\)], "Output"],

Cell[BoxData[
    \(x\ \((\[ExponentialE]\^z\ y + z\ Sin[y])\)\)], "Output"]
}, Closed]],

Cell[TextData["Check that this is indeed a solution:"], "Text",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[BoxData[
    \(ExpandAll[
      grad[phi[x, y, z], {x, y, z}] == {p[x, y, z], q[x, y, z], 
          r[x, y, z]}]\)], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \(True\)], "Output"]
}, Closed]],

Cell[TextData[
"We have a solution.  The solution can be described implicitly by:"], "Text",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[BoxData[
    \(phi[x, y, z] == 0\)], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \(x\ \((\[ExponentialE]\^z\ y + z\ Sin[y])\) == 0\)], "Output"]
}, Closed]]
}, Closed]]
}, Closed]]
}, Closed]]
}, Open  ]]
},
FrontEndVersion->"4.2 for Macintosh",
ScreenRectangle->{{4, 1024}, {0, 746}},
WindowToolbars->{},
CellGrouping->Automatic,
WindowSize->{659, 387},
WindowMargins->{{36, Automatic}, {Automatic, 13}},
PrivateNotebookOptions->{"ColorPalette"->{RGBColor, 128}},
ShowCellLabel->True,
ShowCellTags->False,
RenderingOptions->{"ObjectDithering"->True,
"RasterDithering"->False},
CharacterEncoding->"MacintoshAutomaticEncoding"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 107, 2, 65, "Subtitle",
  Evaluatable->False],
Cell[1886, 57, 239, 5, 50, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[2150, 66, 51, 0, 53, "Subsubtitle"],
Cell[2204, 68, 101, 2, 27, "Input"],
Cell[2308, 72, 37, 0, 32, "Text"],

Cell[CellGroupData[{
Cell[2370, 76, 60, 1, 27, "Input"],
Cell[2433, 79, 601, 18, 29, "Output"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{
Cell[3083, 103, 138, 3, 52, "Subsubtitle",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[3246, 110, 85, 2, 56, "Section",
  Evaluatable->False],
Cell[3334, 114, 964, 22, 176, "Text",
  Evaluatable->False]
}, Closed]],

Cell[CellGroupData[{
Cell[4335, 141, 89, 2, 56, "Section",
  Evaluatable->False],
Cell[4427, 145, 590, 15, 86, "Text",
  Evaluatable->False]
}, Closed]],

Cell[CellGroupData[{
Cell[5054, 165, 94, 2, 56, "Section",
  Evaluatable->False],
Cell[5151, 169, 568, 15, 68, "Text",
  Evaluatable->False],
Cell[5722, 186, 273, 7, 33, "Text",
  Evaluatable->False]
}, Closed]],

Cell[CellGroupData[{
Cell[6032, 198, 102, 2, 56, "Section",
  Evaluatable->False],
Cell[6137, 202, 166, 4, 32, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[6328, 210, 90, 2, 46, "Subsection",
  Evaluatable->False],
Cell[6421, 214, 67, 1, 27, "Input"],
Cell[6491, 217, 185, 6, 32, "Text",
  Evaluatable->False],
Cell[6679, 225, 88, 2, 32, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[6792, 231, 133, 3, 45, "Input"],
Cell[6928, 236, 45, 1, 27, "Output"],
Cell[6976, 239, 53, 1, 29, "Output"]
}, Closed]],
Cell[7044, 243, 108, 2, 32, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[7177, 249, 82, 2, 28, "Input"],
Cell[7262, 253, 40, 1, 27, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[7339, 259, 82, 2, 27, "Input"],
Cell[7424, 263, 40, 1, 27, "Output"]
}, Closed]],
Cell[7479, 267, 167, 4, 32, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[7671, 275, 251, 7, 78, "Input"],
Cell[7925, 284, 35, 1, 27, "Output"],
Cell[7963, 287, 35, 1, 27, "Output"],
Cell[8001, 290, 59, 1, 29, "Output"]
}, Closed]],
Cell[8075, 294, 112, 2, 32, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[8212, 300, 76, 1, 27, "Input"],
Cell[8291, 303, 38, 1, 27, "Output"]
}, Closed]],
Cell[8344, 307, 141, 3, 32, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[8510, 314, 72, 2, 27, "Input"],
Cell[8585, 318, 64, 1, 29, "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[8698, 325, 90, 2, 46, "Subsection",
  Evaluatable->False],
Cell[8791, 329, 67, 1, 27, "Input"],
Cell[8861, 332, 185, 6, 32, "Text",
  Evaluatable->False],
Cell[9049, 340, 88, 2, 32, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[9162, 346, 118, 3, 45, "Input"],
Cell[9283, 351, 41, 1, 27, "Output"],
Cell[9327, 354, 47, 1, 29, "Output"]
}, Closed]],
Cell[9389, 358, 108, 2, 32, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[9522, 364, 82, 2, 28, "Input"],
Cell[9607, 368, 38, 1, 27, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[9682, 374, 82, 2, 27, "Input"],
Cell[9767, 378, 38, 1, 27, "Output"]
}, Closed]],
Cell[9820, 382, 167, 4, 32, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[10012, 390, 251, 7, 78, "Input"],
Cell[10266, 399, 35, 1, 27, "Output"],
Cell[10304, 402, 35, 1, 27, "Output"],
Cell[10342, 405, 116, 2, 45, "Output"]
}, Closed]],
Cell[10473, 410, 112, 2, 32, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[10610, 416, 103, 2, 27, "Input"],
Cell[10716, 420, 38, 1, 27, "Output"]
}, Closed]],
Cell[10769, 424, 141, 3, 32, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[10935, 431, 84, 2, 27, "Input"],
Cell[11022, 435, 61, 1, 29, "Output"]
}, Closed]]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[11156, 444, 140, 3, 52, "Subsubtitle",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[11321, 451, 75, 2, 56, "Section",
  Evaluatable->False],
Cell[11399, 455, 1128, 26, 176, "Text",
  Evaluatable->False]
}, Closed]],

Cell[CellGroupData[{
Cell[12564, 486, 89, 2, 56, "Section",
  Evaluatable->False],
Cell[12656, 490, 1605, 45, 153, "Text",
  Evaluatable->False]
}, Closed]],

Cell[CellGroupData[{
Cell[14298, 540, 94, 2, 56, "Section",
  Evaluatable->False],
Cell[14395, 544, 811, 20, 122, "Text",
  Evaluatable->False],
Cell[15209, 566, 306, 7, 46, "Text",
  Evaluatable->False]
}, Closed]],

Cell[CellGroupData[{
Cell[15552, 578, 104, 2, 56, "Section",
  Evaluatable->False],
Cell[15659, 582, 168, 4, 32, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[15852, 590, 90, 2, 46, "Subsection",
  Evaluatable->False],
Cell[15945, 594, 339, 9, 50, "Text",
  Evaluatable->False],
Cell[16287, 605, 88, 2, 32, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[16400, 611, 291, 5, 81, "Input"],
Cell[16694, 618, 61, 1, 29, "Output"],
Cell[16758, 621, 70, 1, 29, "Output"],
Cell[16831, 624, 64, 1, 29, "Output"]
}, Closed]],
Cell[16910, 628, 108, 2, 32, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[17043, 634, 115, 2, 28, "Input"],
Cell[17161, 638, 38, 1, 27, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[17236, 644, 115, 2, 27, "Input"],
Cell[17354, 648, 38, 1, 27, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[17429, 654, 115, 2, 28, "Input"],
Cell[17547, 658, 38, 1, 27, "Output"]
}, Closed]],
Cell[17600, 662, 174, 5, 32, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[17799, 671, 358, 9, 94, "Input"],
Cell[18160, 682, 35, 1, 27, "Output"],
Cell[18198, 685, 40, 1, 27, "Output"],
Cell[18241, 688, 35, 1, 27, "Output"],
Cell[18279, 691, 101, 2, 29, "Output"]
}, Closed]],
Cell[18395, 696, 112, 2, 32, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[18532, 702, 158, 4, 43, "Input"],
Cell[18693, 708, 38, 1, 27, "Output"]
}, Closed]],
Cell[18746, 712, 141, 3, 32, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[18912, 719, 88, 2, 27, "Input"],
Cell[19003, 723, 106, 2, 29, "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[19158, 731, 90, 2, 46, "Subsection",
  Evaluatable->False],
Cell[19251, 735, 103, 2, 32, "Text",
  Evaluatable->False],
Cell[19357, 739, 201, 4, 29, "Text",
  Evaluatable->False],
Cell[19561, 745, 139, 6, 32, "Text",
  Evaluatable->False],
Cell[19703, 753, 88, 2, 32, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[19816, 759, 247, 5, 75, "Input"],
Cell[20066, 766, 67, 1, 27, "Output"],
Cell[20136, 769, 70, 1, 27, "Output"],
Cell[20209, 772, 70, 1, 27, "Output"]
}, Closed]],
Cell[20294, 776, 108, 2, 32, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[20427, 782, 115, 2, 28, "Input"],
Cell[20545, 786, 38, 1, 27, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[20620, 792, 115, 2, 27, "Input"],
Cell[20738, 796, 38, 1, 27, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[20813, 802, 115, 2, 28, "Input"],
Cell[20931, 806, 38, 1, 27, "Output"]
}, Closed]],
Cell[20984, 810, 167, 4, 32, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[21176, 818, 357, 9, 94, "Input"],
Cell[21536, 829, 35, 1, 27, "Output"],
Cell[21574, 832, 39, 1, 27, "Output"],
Cell[21616, 835, 35, 1, 27, "Output"],
Cell[21654, 838, 76, 1, 27, "Output"]
}, Closed]],
Cell[21745, 842, 112, 2, 32, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[21882, 848, 158, 4, 43, "Input"],
Cell[22043, 854, 38, 1, 27, "Output"]
}, Closed]],
Cell[22096, 858, 141, 3, 32, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[22262, 865, 77, 2, 27, "Input"],
Cell[22342, 869, 81, 1, 27, "Output"]
}, Closed]]
}, Closed]]
}, Closed]]
}, Closed]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

